/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class StoneshieldModifier
extends DurabilityShieldModifier {
    @Override
    protected int getShieldCapacity(IToolStackView tool, int level) {
        return (int)((float)(level * 100) * tool.getMultiplier(ToolStats.DURABILITY));
    }

    @Override
    public int getPriority() {
        return 175;
    }

    @Override
    public List<ItemStack> processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        int addedShield = 0;
        float chance = (float)level * 0.2f;
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!stack.m_204117_(TinkerTags.Items.STONESHIELDS)) continue;
            if (chance >= 1.0f) {
                addedShield += stack.m_41613_();
                iterator.remove();
                continue;
            }
            int reduced = 0;
            for (int i = 0; i < stack.m_41613_(); ++i) {
                if (!(RANDOM.nextFloat() < chance)) continue;
                ++reduced;
            }
            if (reduced == stack.m_41613_()) {
                iterator.remove();
            } else {
                stack.m_41774_(reduced);
            }
            addedShield += reduced;
        }
        if (addedShield > 0) {
            this.addShield(tool, level, addedShield * 3);
        }
        return generatedLoot;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, int level) {
        return this.getShield(tool) > 0 ? Boolean.valueOf(true) : null;
    }

    @Override
    public int getDurabilityRGB(IToolStackView tool, int level) {
        if (this.getShield(tool) > 0) {
            return 0x7F7F7F;
        }
        return -1;
    }
}

